
#ifndef __FA255_ADC_INCLUDE_H_
#define __FA255_ADC_INCLUDE_H_


#include <math.h>
#include <stdio.h>
#include <intrins.h>
#include "REG_MG82F6P32.H"
#include "typedef.h"
#include "config.H"





// declare ADC conversion channel 
typedef enum 
{
    ADC_AIN0=0,
    ADC_AIN1=1,
    ADC_AIN2=2,
    ADC_AIN3=3,
    ADC_AIN4=4,
    ADC_AIN5=5,
    ADC_AIN6=6,
    ADC_AIN7=7,
    ADC_IntVREF=0x27,
} ADC_ChannelDef;

// declare ADC conversion clock select 
typedef enum 
{
    ADC_SYSCLK=0x10,
    ADC_SYSCLKD2=0,
    ADC_SYSCLKD4=0x20,
    ADC_SYSCLKD8=0x40,
    ADC_SYSCLKD16=0x60,
    ADC_SYSCLKD32=0x80,
		ADC_SYSCLKD64=0xA0,
    ADC_S1TOFD2=0xC0,
    ADC_T0OFD2=0xE0,
} ADC_ClockDef;
    
/** 
 * @enum		ADC_DataAlignModeDef
 * @brief		config data alignment mode (Right/Left alignment)
 */        
typedef enum 
{ 
    ADC_LeftJustified=0x00,  /*!< Left Justified of ADC conversion data format  */
    ADC_RightJustified=0x10, /*!< Right Justified of ADC conversion data format */
} ADC_DataAlignModeDef;

/** 
 * @enum		ADC_TriggerSourceDef
 * @brief		ADC0 start control source select
 */        
typedef enum 
{ 
    ADC_START=0x0,          /*!< SW : ADC0_START register setting */
    ADC_TM0OF=0x1,          
    ADC_FreeRun=0x2,        
    ADC_S0OF=0x03,
    ADC_KBIET=0x4,         
    ADC_INT1ET=0x5,
    ADC_INT2ET=0x6,
    ADC_KBIET7=0x7,
    ADC_T2EXES=0x8,
    ADC_KBIET9=0x9,
    ADC_T3EXES=0xA,
    ADC_KBIETB=0xB,
		ADC_C0TOF=0xC,
    ADC_C0CMP6=0xD,
    ADC_C0MP6_or_C0MP7=0xE,
    ADC_KBIETF=0xF,
} ADC_TriggerSourceDef;

// ADC conversion power level select
typedef enum 
{
    ADC_HighestPower=0x00,
    ADC_MiddleHigh=0x40,
    ADC_MiddleLow=0x80,
    ADC_LowPower=0xC0,
} ADC_ConversionPowerDef;

// ADC Resolution select ADCFG3(bit3 bit2)(page=3) 
typedef enum 
{
    ADC_12bit=0x00,//default
    ADC_10bit=0x04,
    ADC_8bit=0x08,
} ADC_ResolutionDef;

// announce function name
void ADC_Cmd(FunctionalState NewState);
void ADC_Channel_Select(ADC_ChannelDef ADCSel);
void ADC_StartConversion();
FlagReturn ADC_GetConversionFlag();
void ADC_ClearFlag();
void ADC_Clock_Select(ADC_ClockDef ADCClkSel);
void ADC_DataAlignment_Select(ADC_DataAlignModeDef AlignMode);
void ADC_SetConversionPower(ADC_ConversionPowerDef PowerSel);
U16 ADC_GetConversionData();
void Initial_ADC();
#endif

